
/**
 ******************************************************************************
 *
 * @file        BSP_SARADCKey.c
 * @brief       Scan user press key by ADC. 
 *
 * @par         Project
 *              MG32
 * @version     V1.02
 * @date        2022/08/01
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */

/*==============================================================================
                                 User NOTES
How To use this function:
   + If want control own parameter after BSP_SARADCKey_Init(),you can write 
     BSP_SARADCKey_InitCallback() to replace.
   + Use BSP_SARADCKey_GetStatus() to get current SARADC key status.
   
Driver & middleware architecture:
--------------------
   + MG32_GPIO_DRV
   + MG32_ADC_MID
   
==============================================================================*/

/* Includes ------------------------------------------------------------------*/


#include "BSP_SARADCKey.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

static uint32_t const  SKEY_LVTable[SKEY_TOTAL_COMBINATION] = {SKey0_LV,SKey1_LV,SKey2_LV,SKey3_LV};
static uint32_t const  SKEY_HVTable[SKEY_TOTAL_COMBINATION] = {SKey0_HV,SKey1_HV,SKey2_HV,SKey3_HV};
static uint32_t const  SKEY_Table[SKEY_TOTAL_COMBINATION] = 
                                                          {
                                                              SKEY0_MASK,
                                                              SKEY1_MASK,
                                                              SKEY2_MASK,
                                                              SKEY3_MASK,
                                                          };    
                                                                                                        
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	  BSP SARADC key initial.   
 * @details   
 * @return    
 * @exception No
 * @note      Becase ADC share with Touch key, ADC initial in BSP_Common_MG04_06.c
 *******************************************************************************
 */ 
void BSP_SARADCKey_Init(void)
{
//    ADC_InitTypeDef    ADC_BastInitTmp;
//    
//    /*Configure ADC base parameter*/
//    ADC_BastInitTmp.ADCMainClockSelect   = ADC_CKADC;
//    ADC_BastInitTmp.ADC_IntCK_Div        = ADC_IntDIV2;
//    ADC_BastInitTmp.ADC_CKPLL_Div        = ADC_PLLDIV2;
//    ADC_BastInitTmp.ADC_DataAlign        = ADC_RightJustified;
//    ADC_BastInitTmp.ADC_ResolutionSel    = ADC_12BitData;
//    ADC_BastInitTmp.ADC_DataOverrunEvent = ADC_DataOverWritten;
//    
//    ADC_Base_Init(MG04_06_ADC, &ADC_BastInitTmp);
//    
//    /*Enable ADC*/
//    ADC_Cmd(MG04_06_ADC,ENABLE);
//    
//    /*Configure ADC mode*/
//    //One-shot 
//    ADC_ConversionMode_Select(MG04_06_ADC, ADCMode); 
//    //Single mode.
//    ADC_SingleDifferentMode_Select(MG04_06_ADC, ADC_SingleMode);
//    
//    /*Clear all flag*/
//    ADC_ClearFlag(MG04_06_ADC, 0xFFFFFFFF);
//    
//    /*Start calibration*/
//    ADC_StartCalibration(MG04_06_ADC, ENABLE);
//    
//    /*Input channel Mux is external channel.*/
//    ADC_ChannelMUX_Select( MG04_06_ADC, ADC_ExternalChannel);
//    
//    /*Trigger source select*/
//    ADC_TriggerSource_Select(MG04_06_ADC, ADC_START);
}


/**
 *******************************************************************************
 * @brief	    Sample serial key matrix and decode it.  
 * @details     
 * @return      
 * @exception   No
 * @note        Becase ADC share with Touch key, ADC initial in BSP_Common_MG04_06.c
 *******************************************************************************
 */ 
uint32_t BSP_SARADCKey_GetStatus(void)
{
    uint16_t    ADCData;
    uint8_t     API_ADCGetSKEY_Tmp;
    
    // select Serial Key channel of ADC
    __BSP_ADC_EXCHANNEL(SARADCKEY_ADCCANNEL);

    // Trigger ADC Conversion
    __BSP_ADC_START_SW();
    
    //  poll ADC flag
    while((MG04_06_ADC->STA.W & ADC_E1CNVF)==0);

    // ------------------------------------------------------------------------
    // determination serial Key0~Key8
    // ------------------------------------------------------------------------
    ADCData = (uint16_t)__BSP_ADC_GETDATA();
    
    // Bisection method
    for( API_ADCGetSKEY_Tmp = 0; API_ADCGetSKEY_Tmp < SKEY_TOTAL_COMBINATION  ; API_ADCGetSKEY_Tmp++)
    {
        if( (SKEY_LVTable[API_ADCGetSKEY_Tmp] < ADCData) && (SKEY_HVTable[API_ADCGetSKEY_Tmp] > ADCData))
        {
            return(SKEY_Table[API_ADCGetSKEY_Tmp]);
        }
    }
    return 0;
}

/**
 *******************************************************************************
 * @brief	    Callback function after BSP_SARADCKey initial completing.   
 * @details     
 * @return      
 * @exception   No
 * @note
 *******************************************************************************
 */                                                                                                             
__WEAK void BSP_SARADCKey_InitCallback(void)
{
    //=========================================================
    //NOTE : This function should not be modifyed, when the 
    //       callback is needed, the MID_URT_RxCpltCallback 
    //       can be implemented in the user file.    
}

















